/***********************************************************************
 * $Id:: font.h 8242 2011-10-11 15:15:25Z nxp28536                     $
 *
 * Project: LPC43xx Common
 *
 * Description:
 *     This file contains a font library for a 8x8 matrix display
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

#include <stdio.h>
#include "LPC43xx.H"                    /* LPC43xx definitions */

#ifndef FONT_H_
#define FONT_H_

#define MAX_CHARS 59
#define CHAR_OFFSET 0x20

const uint8_t font[] = {
  // 3 chars bitmap, 1 char length
   0x00, 0x00, 0x00, 0x01 ,		// 0x20, 32, ' '	
   0x17, 0x00, 0x00, 0x01 ,		// 0x21, 33, !	
   0x03, 0x00, 0x03, 0x03 ,		// 0x22, 34, "	
   0x00, 0x00, 0x00, 0x03 ,		// 0x23, 35, #	
   0x00, 0x00, 0x00, 0x03 ,		// 0x24, 36, $	
   0x00, 0x00, 0x00, 0x03 ,		// 0x25, 37, %	
   0x00, 0x00, 0x00, 0x03 ,		// 0x26, 38, &	
   0x03, 0x00, 0x00, 0x01 ,		// 0x27, 39, '	
   0x0e, 0x11, 0x00, 0x02 ,		// 0x28, 40, (	
   0x11, 0x0e, 0x00, 0x02 ,		// 0x29, 41, )	
   0x00, 0x00, 0x00, 0x03 ,		// 0x2A, 42, *	
   0x08, 0x1c, 0x08, 0x03 ,		// 0x2B, 43, +	
   0x18, 0x00, 0x00, 0x01 ,		// 0x2C, 44, ,	
   0x04, 0x04, 0x00, 0x03 ,		// 0x2D, 45, -	
   0x10, 0x00, 0x00, 0x01 ,		// 0x2E, 46, .	
   0x18, 0x04, 0x03, 0x03 ,		// 0x2F, 47, /	
   0x1f, 0x11, 0x1f, 0x03 ,		// 0x30, 48, 0
   0x01, 0x1f, 0x00, 0x02 ,		// 0x31, 49, 1
   0x1d, 0x15, 0x17, 0x03 ,		// 0x32, 50, 2
   0x15, 0x15, 0x0e, 0x03 ,		// 0x33, 51, 3
   0x0f, 0x08, 0x1f, 0x03 ,		// 0x34, 52, 4
   0x17, 0x15, 0x1d, 0x03 ,		// 0x35, 53, 5
   0x1f, 0x12, 0x1e, 0x03 ,		// 0x36, 54, 6
   0x11, 0x09, 0x07, 0x03 ,		// 0x37, 55, 7
   0x1f, 0x15, 0x1f, 0x03 ,		// 0x38, 56, 8
   0x0f, 0x09, 0x1f, 0x03 ,		// 0x39, 57, 9	
   0x0a, 0x00, 0x00, 0x01 ,		// 0x3A, 58, :
   0x1a, 0x00, 0x00, 0x01 ,		// 0x3B, 59, ;	
   0x08, 0x14, 0x00, 0x02 ,		// 0x3C, 60, <	
   0x14, 0x14, 0x00, 0x02 ,		// 0x3D, 61, =	
   0x14, 0x08, 0x00, 0x02 ,		// 0x3E, 62, >	
   0x15, 0x05, 0x02, 0x03 ,		// 0x3F, 63, ?	
   0x0e, 0x17, 0x16, 0x03 ,		// 0x40, 64, @	
   0x1f, 0x09, 0x1e, 0x03 ,		// 0x41, 65, A
   0x1f, 0x15, 0x0a, 0x03 ,		// 0x42, 66, B
   0x0e, 0x11, 0x11, 0x03 ,		// 0x43, 67, C
   0x1f, 0x11, 0x0e, 0x03 ,		// 0x44, 68, D
   0x0e, 0x15, 0x15, 0x03 ,		// 0x45, 69, E
   0x1e, 0x05, 0x05, 0x03 ,		// 0x46, 70, F
   0x0e, 0x11, 0x1d, 0x03 ,		// 0x47, 71, G
   0x1f, 0x04, 0x1f, 0x03 ,		// 0x48, 72, H
   0x1f, 0x00, 0x00, 0x01 ,		// 0x49, 73, I
   0x08, 0x10, 0x0f, 0x03 ,		// 0x4A, 74, J
   0x1f, 0x04, 0x1b, 0x03 ,		// 0x4B, 75, K
   0x0f, 0x10, 0x10, 0x03 ,		// 0x4C, 76, L
   0x1f, 0x02, 0x1f, 0x03 ,		// 0x4D, 77, M
   0x1f, 0x01, 0x1e, 0x03 ,		// 0x4E, 78, N
   0x0e, 0x11, 0x0e, 0x03 ,		// 0x4F, 79, O
   0x1f, 0x09, 0x06, 0x03 ,		// 0x50, 80, P
   0x06, 0x19, 0x06, 0x03 ,		// 0x51, 81, Q
   0x1f, 0x09, 0x16, 0x03 ,		// 0x52, 82, R
   0x12, 0x15, 0x09, 0x03 ,		// 0x53, 83, S
   0x01, 0x1f, 0x01, 0x03 ,		// 0x54, 84, T
   0x0f, 0x10, 0x0f, 0x03 ,		// 0x55, 85, U
   0x1f, 0x10, 0x0f, 0x03 ,		// 0x56, 86, V
   0x1f, 0x08, 0x1f, 0x03 ,		// 0x57, 87, W
   0x1b, 0x04, 0x1b, 0x03 ,		// 0x58, 88, X
   0x03, 0x1c, 0x03, 0x03 ,		// 0x59, 89, Y
   0x19, 0x15, 0x13, 0x03 ,		// 0x5A, 90, Z
   0x1f, 0x11, 0x00, 0x02 ,		// 0x5B, 91, [
   0x03, 0x04, 0x18, 0x03 ,		// 0x5C, 92, 
   0x11, 0x1f, 0x00, 0x02 ,		// 0x5D, 93, [
   0x11, 0x1f, 0x00, 0x02 ,		// 0x5E, 94, ^
   0x1f, 0x1f, 0x1f, 0x03 		// 0x5F, 95, _, used as block, all on
};

#endif /*FONT_H_*/
